/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.support;

import com.ibm.hwmca.base.managed.BaseTaskKeys;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.servlet.util.ServletRuntime;
import com.ibm.hwmca.fw.tasklet.Client;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.util.Trace;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SupportServlet
extends HttpServlet {
    private static final String TRACE_MASKT = "XFRMSSVT";
    private static final String TRACE_MASKF = "XFRMSSVF";
    private static final String TRACE_MASKD = "XFRMSSVD";
    private static final String REQTYPE_FILE = "file";
    private static final String REQTYPE_FILELIST = "filelist";
    private static final String REQTYPE_COMMAND = "command";
    private static final String REQTYPE_DIRFLOPPY = "dirfloppy";
    private static final String REQTYPE_DIRDVD = "dirdvd";
    private static final String REQTYPE_FRAME = "frame";
    private static final String REQTYPE_EMPTY = "empty";
    private static final String MIME_TEXT_HTML = "text/html";
    private static final String MIME_TEXT_PLAIN = "text/plain";
    private static final String MIME_BINARY_DATA = "application/bin";
    private static final String MIME_ZIP = "application/zip";
    private static final String ERASE_PARM = "erase";
    private static final String REQTYPE_LISTOFFILES = "listoffiles";
    private transient ResourceBundle bundle;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Trace.trace(TRACE_MASKF, "-> SupportServlet.doGet");
        response.setHeader("Cache-Control", "no-cache");
        ServletRuntime.getRuntime().attachUserContextToServletThread(request);
        if (this.isAuthorized(request, response)) {
            this.bundle = ResourceBundle.getBundle("com.ibm.hwmca.fw.servlet.support.res.supportservlet");
            String input = request.getParameter("InputData");
            String reqtype = request.getParameter("reqtype");
            if (REQTYPE_COMMAND.equals(reqtype)) {
                this.doCommand(response, request, input);
            } else if (REQTYPE_FILE.equals(reqtype)) {
                String erase = request.getParameter(ERASE_PARM);
                this.returnFile(response, MIME_BINARY_DATA, input, "true".equals(erase));
            } else if (REQTYPE_FILELIST.equals(reqtype)) {
                this.returnFilesAsZip(response, input);
            } else if (REQTYPE_LISTOFFILES.equals(reqtype)) {
                String erase = request.getParameter(ERASE_PARM);
                this.returnFileListAsZip(response, input, "true".equals(erase));
            } else if (REQTYPE_DIRFLOPPY.equals(reqtype)) {
                this.doDirectory(response, "/media/floppy");
            } else if (REQTYPE_DIRDVD.equals(reqtype)) {
                this.doDirectory(response, "/media/cdrom");
            } else if (REQTYPE_FRAME.equals(reqtype)) {
                this.doDialogFrame(request, response);
            } else if (REQTYPE_EMPTY.equals(reqtype)) {
                this.doEmptyPage(response);
            } else {
                this.doDefaultDialog(request, response);
            }
        }
        Trace.trace(TRACE_MASKF, "<- SupportServlet.doGet");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private void doDefaultDialog(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Trace.trace(TRACE_MASKF, "-> SupportServlet.doDefaultDialog");
        response.setContentType(MIME_TEXT_HTML);
        PrintWriter out = response.getWriter();
        Object[] subst = new Object[]{this.getTitle("frame.title")};
        String markup = MessageFormat.format(this.bundle.getString("frame.markup"), subst);
        out.print(markup);
        Trace.trace(TRACE_MASKF, "-> SupportServlet.doDefaultDialog");
    }

    private void doDialogFrame(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Trace.trace(TRACE_MASKF, "-> SupportServlet.doDialogFrame");
        response.setContentType(MIME_TEXT_HTML);
        PrintWriter out = response.getWriter();
        Object[] subst = new Object[]{this.getTitle("frame.title"), this.bundle.getString("dialog.input.text"), this.bundle.getString("dialog.action.text"), this.bundle.getString("dialog.command.text"), this.bundle.getString("dialog.file.text"), this.bundle.getString("dialog.filelist.text"), this.bundle.getString("dialog.dirfloppy.text"), this.bundle.getString("dialog.dirdvd.text"), this.bundle.getString("dialog.submit.text")};
        String markup = MessageFormat.format(this.bundle.getString("dialog.markup"), subst);
        out.print(markup);
        Trace.trace(TRACE_MASKF, "<- SupportServlet.doDialogFrame");
    }

    private void returnFileListAsZip(HttpServletResponse response, String filename, boolean erase) throws IOException {
        Trace.trace(TRACE_MASKF, "-> SupportServlet.returnFileListAsZip");
        File file = new File(filename);
        if (file.exists()) {
            try {
                String cmd = "cat " + filename;
                Process pid = Runtime.getRuntime().exec(cmd);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                InputStream in = pid.getInputStream();
                byte[] buf = new byte[256];
                int bytes = 0;
                while (bytes != -1) {
                    bytes = in.read(buf, 0, buf.length);
                    if (bytes == -1) continue;
                    out.write(buf, 0, bytes);
                }
                in.close();
                String files = out.toString().replace('\n', ' ');
                this.returnFilesAsZip(response, files);
                if (erase) {
                    file.delete();
                }
            }
            catch (IOException e) {
                PrintWriter out = response.getWriter();
                out.print(e.getMessage());
            }
        } else {
            ServletOutputStream out = response.getOutputStream();
            response.setContentType(MIME_TEXT_HTML);
            out.print(this.bundle.getString("output.markup.start"));
            out.print(this.bundle.getString("invalid.request.badlist"));
            out.print(this.bundle.getString("output.markup.end"));
        }
        Trace.trace(TRACE_MASKF, "<- SupportServlet.returnFileListAsZip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnFile(HttpServletResponse response, String mimeType, String filename, boolean erase) throws IOException {
        Trace.trace(TRACE_MASKF, "-> SupportServlet.returnFile");
        File file = new File(filename);
        if (file.exists()) {
            if (file.isFile()) {
                response.setContentType(mimeType);
                response.setHeader("Content-Disposition:", "attachment; filename=\"" + file.getName() + "\"");
                FileInputStream in = new FileInputStream(file);
                try {
                    ServletOutputStream out = response.getOutputStream();
                    byte[] buf = new byte[256];
                    int bytes = 0;
                    while (bytes != -1) {
                        bytes = in.read(buf, 0, buf.length);
                        if (bytes == -1) continue;
                        out.write(buf, 0, bytes);
                    }
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "caught IOException reading specified file");
                    Trace.trace(TRACE_MASKF, e);
                }
                finally {
                    in.close();
                }
                if (erase) {
                    file.delete();
                }
            } else {
                ServletOutputStream out = response.getOutputStream();
                response.setContentType(MIME_TEXT_HTML);
                out.print(this.bundle.getString("output.markup.start"));
                out.print(this.bundle.getString("invalid.request.notafile"));
                out.print(this.bundle.getString("output.markup.end"));
            }
        } else {
            ServletOutputStream out = response.getOutputStream();
            response.setContentType(MIME_TEXT_HTML);
            out.print(this.bundle.getString("output.markup.start"));
            out.print(this.bundle.getString("invalid.request.badfile"));
            out.print(this.bundle.getString("output.markup.end"));
        }
        Trace.trace(TRACE_MASKF, "<- SupportServlet.returnFile");
    }

    private void returnFilesAsZip(HttpServletResponse response, String files) throws IOException {
        Trace.trace(TRACE_MASKF, "-> SupportServlet.returnFilesAsZip");
        File zipfile = File.createTempFile("support", ".zip");
        zipfile.delete();
        String cmd = "zip " + zipfile.getAbsolutePath() + " " + files;
        Trace.trace(TRACE_MASKF, "issuing zip cmd=[" + cmd + "]");
        int rc = this.issueCommand(cmd);
        if (rc == 0) {
            this.returnFile(response, MIME_ZIP, zipfile.getAbsolutePath(), true);
        } else {
            ServletOutputStream out = response.getOutputStream();
            response.setContentType(MIME_TEXT_HTML);
            out.print(this.bundle.getString("output.markup.start"));
            out.print(this.bundle.getString("error.building.zip"));
            out.print(this.bundle.getString("output.markup.end"));
        }
        Trace.trace(TRACE_MASKF, "<- SupportServlet.returnFilesAsZip");
    }

    private void doCommand(HttpServletResponse response, HttpServletRequest request, String command) throws IOException {
        Trace.trace(TRACE_MASKF, "-> SupportServlet.doCommand");
        response.setContentType(MIME_TEXT_HTML);
        Object[] subst = new Object[]{command};
        ServletOutputStream out = response.getOutputStream();
        try {
            out.print(this.bundle.getString("output.markup.start"));
            out.print("<b>" + MessageFormat.format(this.getTitle("dialog.command.header"), subst) + "</b>");
            out.print(this.bundle.getString("output.markup.prestart"));
            String cmd = request != null ? "support DISPLAY=" + request.getRemoteAddr() + ":0 " + command.trim() : "support DISPLAY=127.0.0.1:0 " + command.trim();
            Process pid = Runtime.getRuntime().exec(cmd);
            if (cmd.endsWith("&")) {
                out.print(this.bundle.getString("async.start"));
            } else {
                InputStream in = pid.getInputStream();
                byte[] buf = new byte[256];
                int bytes = 0;
                while (bytes != -1) {
                    bytes = in.read(buf, 0, buf.length);
                    if (bytes == -1) continue;
                    out.write(buf, 0, bytes);
                }
                in.close();
            }
            out.print(this.bundle.getString("output.markup.preend"));
            out.print(this.bundle.getString("output.markup.end"));
        }
        catch (IOException e) {
            out.print(e.getMessage());
        }
        Trace.trace(TRACE_MASKF, "<- SupportServlet.doCommand");
    }

    private void doEmptyPage(HttpServletResponse response) throws IOException {
        Trace.trace(TRACE_MASKF, "-> SupportServlet.doEmptyPage");
        response.setContentType(MIME_TEXT_HTML);
        try {
            ServletOutputStream out = response.getOutputStream();
            out.print(this.bundle.getString("output.markup.start"));
            out.print(this.bundle.getString("output.markup.end"));
        }
        catch (IOException e) {
            PrintWriter out = response.getWriter();
            out.print(e.getMessage());
        }
        Trace.trace(TRACE_MASKF, "<- SupportServlet.doEmptyPage");
    }

    private void doDirectory(HttpServletResponse response, String mountPoint) throws IOException {
        Trace.trace(TRACE_MASKF, "-> SupportServlet.doDirectory");
        int rc = 0;
        int mountedRc = this.issueCommand("mount " + mountPoint);
        this.doCommand(response, null, "ls -al " + mountPoint);
        if (mountedRc == 0) {
            rc = this.issueCommand("umount " + mountPoint);
        }
        Trace.trace(TRACE_MASKF, "<- SupportServlet.doDirectory");
    }

    private int issueCommand(String command) throws IOException {
        Trace.trace(TRACE_MASKF, "-> SupportServlet.issueCommand(" + command + ")");
        Process process = Runtime.getRuntime().exec(command);
        boolean keepWaiting = true;
        while (keepWaiting) {
            try {
                process.waitFor();
                keepWaiting = false;
            }
            catch (InterruptedException e) {}
        }
        Trace.trace(TRACE_MASKF, "<- SupportServlet.issueCommand(" + process.exitValue() + ")");
        return process.exitValue();
    }

    private boolean isAuthorized(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean isAuth = false;
        Trace.trace(TRACE_MASKF, "-> SupportServlet.isAuthorized()");
        try {
            ObjectId oid = BaseTaskKeys.getObjectIdFromKey("base.task.support");
            Client authClient = new Client("com.ibm.hwmca.fw.servlet.support.SupportAuthTasklet", oid);
            TaskletResponse resp = authClient.init();
            Boolean auth = (Boolean)resp.getData("authorized");
            if (auth != null) {
                isAuth = auth;
            }
            if (!isAuth) {
                ServletOutputStream out = response.getOutputStream();
                response.setContentType(MIME_TEXT_HTML);
                out.print(this.bundle.getString("output.markup.start"));
                out.print(this.bundle.getString("not.authorized"));
                out.print(this.bundle.getString("output.markup.end"));
            }
        }
        catch (TaskletException e) {
            isAuth = false;
            Trace.trace(TRACE_MASKF, e);
            response.sendError(500, "Internal error: " + e);
        }
        Trace.trace(TRACE_MASKF, "<- SupportServlet.isAuthorized(" + isAuth + ")");
        return isAuth;
    }

    private String getTitle(String key) {
        String format = this.bundle.getString("title.format");
        Object[] subst = new String[]{HMC.getHMC().getUIInfo().getTitle(), this.bundle.getString(key)};
        return MessageFormat.format(format, subst);
    }
}

